package gov.va.genisis2.model;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * The Class StudyApproval.
 * 
 * Description: In this StudyApproval Class implements the interface Serializable
 * and defines the entity and data mapping for the dbo.User_Approver Table in
 * the database.
 */
@Entity
@Table(name = "StudyApproval", schema = "dbo")
@JsonIgnoreProperties({ "processId", "approvalIdObtained", "modifiedOn", "associatedStudyApproval1",
		"associatedStudyApproval2", "associatedStudyApproval3", "requests" })
public class StudyApproval implements java.io.Serializable {

	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = -194113809816029192L;

	/** The id. */
	private int id;

	/** The process id. */
	private int processId;
	
	/** The approval id obtained. */
	private String approvalIdObtained;
	
	/** The title. */
	private String title;

	/** The description. */
	private String description;

	/** The created on. */
	private Date createdOn;

	/** The modified on. */
	private Date modifiedOn;
	
	/** The created by. */
	private String createdBy;
	
	/** The modified by. */
	private String modifiedBy;

	/** The associated study approval 1. */
	private Integer associatedStudyApproval1;

	/** The associated study approval 2. */
	private Integer associatedStudyApproval2;

	/** The associated study approval 3. */
	private Integer associatedStudyApproval3;

	/** The obtained. */
	private String obtained;
	
	/** The associated approvals. */
	private List<Integer> associatedApprovals;
	
	/** The Requests */
	private Set<Request> requests = new HashSet<>(0);

	/**
	 * Instantiates a new study approval.
	 */
	public StudyApproval() {
		// Do nothing. The method is an intentionally-blank override.
	}

	/**
	 * @param id  This Id
	 */
	public StudyApproval(int id) {
			this.id = id;
	}

	/**
	 * Instantiates a new study approval.
	 *
	 * @param id the id
	 * @param processId the process id
	 */
	public StudyApproval(int id, int processId) {
		this.id = id;
		this.processId = processId;
	}

	/**
	 * Instantiates a new study approval.
	 *
	 * @param approvalIdObtained the approval id obtained
	 * @param id the id
	 * @param processId the process id
	 * @param title the title
	 * @param description the description
	 * @param createdOn the created on
	 * @param modifiedOn the modified on
	 * @param createdBy the created by
	 * @param modifiedBy the modified by
	 * @param associatedStudyApproval1 the associated study approval 1
	 * @param associatedStudyApproval2 the associated study approval 2
	 * @param associatedStudyApproval3 the associated study approval 3
	  @param requests the Requests
	 */
	public StudyApproval(String approvalIdObtained, int id, int processId, String title, String description,
			Date createdOn, Date modifiedOn, String createdBy, String modifiedBy, Integer associatedStudyApproval1,
			Integer associatedStudyApproval2, Integer associatedStudyApproval3, Set<Request> requests) {
		this.approvalIdObtained = approvalIdObtained;
		this.id = id;
		this.processId = processId;
		this.title = title;
		this.description = description;
		this.createdOn = createdOn;
		this.modifiedOn = modifiedOn;
		this.createdBy = createdBy;
		this.modifiedBy = modifiedBy;
		this.associatedStudyApproval1 = associatedStudyApproval1;
		this.associatedStudyApproval2 = associatedStudyApproval2;
		this.associatedStudyApproval3 = associatedStudyApproval3;
		this.requests = requests;
	}

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	@Id
	@Column(name = "Id", unique = true, nullable = false)
	public int getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id the new id
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Gets the process id.
	 *
	 * @return the process id
	 */
	@Column(name = "ProcessId", nullable = false)
	public int getProcessId() {
		return this.processId;
	}

	/**
	 * Sets the process id.
	 *
	 * @param processId the new process id
	 */
	public void setProcessId(int processId) {
		this.processId = processId;
	}

	/**
	 * Gets the approval id obtained.
	 *
	 * @return the approval id obtained
	 */
	@Column(name = "ApprovalIdObtained")
	public String getApprovalIdObtained() {
		return this.approvalIdObtained;
	}

	/**
	 * Sets the approval id obtained.
	 *
	 * @param approvalIdObtained the new approval id obtained
	 */
	public void setApprovalIdObtained(String approvalIdObtained) {
		this.approvalIdObtained = approvalIdObtained;
	}

	/**
	 * Gets the title.
	 *
	 * @return the title
	 */
	@Column(name = "Title", length = 50)
	public String getTitle() {
		return this.title;
	}

	/**
	 * Sets the title.
	 *
	 * @param title the new title
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * Gets the description.
	 *
	 * @return the description
	 */
	@Column(name = "Description", length = 3000)
	public String getDescription() {
		return description;
	}

	/**
	 * Sets the description.
	 *
	 * @param description the new description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Gets the created on.
	 *
	 * @return the created on
	 */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "CreatedOn", length = 23)
	public Date getCreatedOn() {
		return this.createdOn;
	}

	/**
	 * Sets the created on.
	 *
	 * @param createdOn the new created on
	 */
	public void setCreatedOn(Date createdOn) {
		this.createdOn = createdOn;
	}

	/**
	 * Gets the modified on.
	 *
	 * @return the modified on
	 */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "ModifiedOn", length = 23)
	public Date getModifiedOn() {
		return this.modifiedOn;
	}

	/**
	 * Sets the modified on.
	 *
	 * @param modifiedOn the new modified on
	 */
	public void setModifiedOn(Date modifiedOn) {
		this.modifiedOn = modifiedOn;
	}

	/**
	 * Gets the created by.
	 *
	 * @return the created by
	 */
	@Column(name = "CreatedBy", length = 50)
	public String getCreatedBy() {
		return this.createdBy;
	}

	/**
	 * Sets the created by.
	 *
	 * @param createdBy the new created by
	 */
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	/**
	 * Gets the modified by.
	 *
	 * @return the modified by
	 */
	@Column(name = "ModifiedBy", length = 50)
	public String getModifiedBy() {
		return this.modifiedBy;
	}

	/**
	 * Sets the modified by.
	 *
	 * @param modifiedBy the new modified by
	 */
	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	/**
	 * Gets the associated study approval 1.
	 *
	 * @return the associated study approval 1
	 */
	@Column(name = "AssociatedStudyApproval1")
	public Integer getAssociatedStudyApproval1() {
		return this.associatedStudyApproval1;
	}

	/**
	 * Sets the associated study approval 1.
	 *
	 * @param associatedStudyApproval1 the new associated study approval 1
	 */
	public void setAssociatedStudyApproval1(Integer associatedStudyApproval1) {
		this.associatedStudyApproval1 = associatedStudyApproval1;
	}

	/**
	 * Gets the associated study approval 2.
	 *
	 * @return the associated study approval 2
	 */
	@Column(name = "AssociatedStudyApproval2")
	public Integer getAssociatedStudyApproval2() {
		return this.associatedStudyApproval2;
	}

	/**
	 * Sets the associated study approval 2.
	 *
	 * @param associatedStudyApproval2 the new associated study approval 2
	 */
	public void setAssociatedStudyApproval2(Integer associatedStudyApproval2) {
		this.associatedStudyApproval2 = associatedStudyApproval2;
	}

	/**
	 * Gets the associated study approval 3.
	 *
	 * @return the associated study approval 3
	 */
	@Column(name = "AssociatedStudyApproval3")
	public Integer getAssociatedStudyApproval3() {
		return this.associatedStudyApproval3;
	}

	/**
	 * Sets the associated study approval 3.
	 *
	 * @param associatedStudyApproval3 the new associated study approval 3
	 */
	public void setAssociatedStudyApproval3(Integer associatedStudyApproval3) {
		this.associatedStudyApproval3 = associatedStudyApproval3;
	}
	/**
	 * Gets the obtained.
	 *
	 * @return the obtained
	 */
	@Transient
	public String getObtained() {
		return obtained;
	}

	/**
	 * Sets the obtained.
	 *
	 * @param obtained the new obtained
	 */
	public void setObtained(String obtained) {
		this.obtained = obtained;
	}

	/**
	 * Gets the associated approvals.
	 *
	 * @return the associated approvals
	 */
	@Transient
	public List<Integer> getAssociatedApprovals() {
		return associatedApprovals;
	}

	/**
	 * Sets the associated approvals.
	 *
	 * @param associatedApprovals the new associated approvals
	 */
	public void setAssociatedApprovals(List<Integer> associatedApprovals) {
		this.associatedApprovals = associatedApprovals;
	}

	
	/**
	 * Gets the requests.
	 *
	 *@return the requests
	 */
	@OneToMany(fetch=FetchType.LAZY, mappedBy="source")
    public Set<Request> getRequests() {
        return this.requests;
    }
    
	/**
	 * Sets the requests
	 *
	 * @param requests the requests
	 * 
	  */
    public void setRequests(Set<Request> requests) {
        this.requests = requests;
    }
}
